/*************************************************************************/ /*!
@File
@Title          Public services interfaces
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@License        MIT

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/ /**************************************************************************/

#ifndef _POWERVR_SERVICES_H_
#define _POWERVR_SERVICES_H_

#if defined (__cplusplus)
extern "C" {
#endif

#include <stdbool.h>
#include <powervr/sync_external.h>

typedef struct _PVRSRV_DEV_CONNECTION_ PVRSRV_DEV_CONNECTION;

typedef struct _PVRSRV_DEVMEMCTX_ *PVRSRV_DEVMEMCTX;
typedef struct _DEVMEM_HEAP_ *PVRSRV_HEAP;
typedef struct _DEVMEM_MEMDESC_ *PVRSRV_MEMDESC;


/* SERVICES ******************************************************************/
bool PVRSRVConnectExt(PVRSRV_DEV_CONNECTION **ppsDevConnection);

bool PVRSRVDisconnectExt(PVRSRV_DEV_CONNECTION *psDevConnection);

bool PVRSRVAcquireGlobalEventHandleExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                       void **ppvEvent);

bool PVRSRVReleaseGlobalEventHandleExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                       void *pvEvent);

bool PVRSRVEventObjectWaitExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                              void *pvEvent);

bool PVRSRVEventObjectWaitTimeoutExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                     void *pvEvent,
                                     uint64_t ui64Timeoutus);


/* PVRSRV_SYNC ***************************************************************/
bool PVRSRVSyncPrimServerAllocExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                  PVRSRV_CLIENT_SYNC_PRIM **ppsSync,
                                  char *pszClassName);

bool PVRSRVSyncPrimFreeExt(PVRSRV_CLIENT_SYNC_PRIM *psSync);


bool PVRSRVSyncPrimOpCreateExt(uint32_t ui32SyncCount,
                               PVRSRV_CLIENT_SYNC_PRIM **papsSyncPrim,
                               PSYNC_OP_COOKIE *ppsCookie);

bool PVRSRVSyncPrimOpTakeExt(PSYNC_OP_COOKIE psCookie,
                             uint32_t ui32SyncOpCount,
                             PVRSRV_CLIENT_SYNC_PRIM_OP *pasSyncOp);

bool PVRSRVSyncPrimOpReadyExt(PSYNC_OP_COOKIE psCookie,
                              bool *pbReady);

bool PVRSRVSyncPrimOpCompleteExt(PSYNC_OP_COOKIE psCookie);

bool PVRSRVSyncPrimOpDestroyExt(PSYNC_OP_COOKIE psCookie);


/* PVRSRV_DEVMEM *************************************************************/
bool PVRSRVCreateDeviceMemContextExt(PVRSRV_DEV_CONNECTION *psDevConnection,
                                     PVRSRV_DEVMEMCTX *phCtxOut);

void PVRSRVDestroyDeviceMemContextExt(PVRSRV_DEVMEMCTX hCtx);

bool PVRSRVFindHeapExt(PVRSRV_DEVMEMCTX hCtx,
                       PVRSRV_HEAP *phHeapOut);


/* PVRSRV_DEVMEM_EXTMEM ******************************************************/
bool PVRSRVWrapExtMemExt(const PVRSRV_DEVMEMCTX psDevMemCtx,
                         IMG_DEVMEM_SIZE_T uiSize,
                         IMG_CPU_VIRTADDR pvCpuVAddr,
                         IMG_DEVMEM_ALIGN_T uiAlign,
                         char *pszText,
                         PVRSRV_MEMDESC *hMemDesc);


/* PVRSRV_DEVMEM_DMABUF ******************************************************/
#if defined(LINUX) || defined(__linux__)

bool PVRSRVDmaBufExportDevMemExt(PVRSRV_MEMDESC hMemDesc,
                                 int *piFd);

bool PVRSRVDmaBufImportDevMemExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                 int fd,
                                 PVRSRV_MEMDESC *phMemDescPtr,
                                 IMG_DEVMEM_SIZE_T *puiSizePtr,
                                 const char *pszName);

bool PVRSRVDMABufAllocDevMemExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                IMG_DEVMEM_SIZE_T uiSize,
                                IMG_DEVMEM_LOG2ALIGN_T uiLog2Align,
                                char *pszName,
                                int *fd,
                                PVRSRV_MEMDESC *phMemDescPtr);

void PVRSRVDMABufReleaseDevMemExt(const PVRSRV_DEV_CONNECTION *psDevConnection,
                                  PVRSRV_MEMDESC hMemDesc,
                                  int fd);

#endif

#if defined (__cplusplus)
}
#endif


#endif
